/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.itemstages;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import javax.annotation.Nullable;
import net.darkhax.gamestages.GameStageHelper;
import net.darkhax.gamestages.data.IStageData;
import net.darkhax.itemstages.Restriction;
import net.minecraft.client.resources.ReloadListener;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.profiler.IProfiler;
import net.minecraft.resources.IResourceManager;

public class RestrictionManager
extends ReloadListener<Void> {
    public static final RestrictionManager INSTANCE = new RestrictionManager();
    private final Multimap<String, Restriction> restrictions = HashMultimap.create();
    private final Multimap<String, Restriction> preventInventory = HashMultimap.create();
    private final Multimap<String, Restriction> preventEquipment = HashMultimap.create();
    private boolean hasBuiltCaches = false;

    private void buildCaches() {
        if (!this.hasBuiltCaches) {
            for (String stage : this.restrictions.keySet()) {
                for (Restriction restriction : this.restrictions.get((Object)stage)) {
                    if (restriction.shouldPreventInventory()) {
                        this.preventInventory.put((Object)stage, (Object)restriction);
                    }
                    if (!restriction.shouldPreventEquipment()) continue;
                    this.preventEquipment.put((Object)stage, (Object)restriction);
                }
            }
            this.hasBuiltCaches = true;
        }
    }

    @Nullable
    public Restriction getRestriction(PlayerEntity player, ItemStack stack) {
        return this.getRestriction(player, GameStageHelper.getPlayerData((PlayerEntity)player), stack, this.restrictions);
    }

    @Nullable
    public Restriction getRestriction(PlayerEntity player, IStageData stageData, ItemStack stack) {
        return this.getRestriction(player, stageData, stack, this.restrictions);
    }

    @Nullable
    public Restriction getInventoryRestriction(PlayerEntity player, IStageData stageData, ItemStack stack) {
        return this.getRestriction(player, stageData, stack, this.preventInventory);
    }

    @Nullable
    public Restriction getEquipmentRestriction(PlayerEntity player, IStageData stageData, ItemStack stack) {
        return this.getRestriction(player, stageData, stack, this.preventEquipment);
    }

    @Nullable
    public Restriction getRestriction(PlayerEntity player, IStageData stageData, ItemStack stack, Multimap<String, Restriction> restrictionPool) {
        if (!stack.func_190926_b()) {
            this.buildCaches();
            for (String stageName : restrictionPool.keySet()) {
                if (GameStageHelper.hasStage((PlayerEntity)player, (IStageData)stageData, (String)stageName)) continue;
                for (Restriction restriction : restrictionPool.get((Object)stageName)) {
                    if (!restriction.isRestricted(stack) || restriction.meetsRequirements(player, stageData)) continue;
                    return restriction;
                }
            }
        }
        return null;
    }

    public void addRestriction(Restriction restriction) {
        restriction.getStages().forEach(stage -> this.restrictions.put(stage, (Object)restriction));
    }

    protected Void prepare(IResourceManager resourceManager, IProfiler profiler) {
        return null;
    }

    protected void apply(Void object, IResourceManager resourceManager, IProfiler profiler) {
        this.hasBuiltCaches = false;
        this.restrictions.clear();
        this.preventInventory.clear();
    }
}

